#include <stdio.h>
#include <stdlib.h>
#include <mpi.h>

int main(int argc, char *argv[]) {
    int N, P, X;
    int rank, size;

    MPI_Init(&argc, &argv);                // Initialize MPI
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);  // Process rank
    MPI_Comm_size(MPI_COMM_WORLD, &size);  // Number of processes

    // Parametrii de intrare
    if (argc != 4) {
        if (rank == 0)
            printf("Usage: %s N P X\n", argv[0]);
        MPI_Finalize();
        return 1;
    }

    N = atoi(argv[1]);
    P = atoi(argv[2]);
    X = atoi(argv[3]);

    if (P != size) {
        if (rank == 0)
            printf("Number of MPI processes must match P\n");
        MPI_Finalize();
        return 1;
    }

    // Initializare vector
    int *v = NULL;
    if (rank == 0) {
        v = (int*)malloc(N * sizeof(int));
        for (int i = 0; i < N; i++)
            v[i] = (i + 3) % 5;
    }

    // Determinarea dimensiunii fragmentului pentru fiecare proces
    int chunk_size = N / size;
    int remainder = N % size;
    int start = rank * chunk_size + (rank < remainder ? rank : remainder);
    int end = start + chunk_size + (rank < remainder ? 1 : 0);

    // Calcul local
    int local_count = 0;
    int local_sum = 0;
    for (int i = start; i < end; i++) {
        int value;
        if (rank == 0)
            value = v[i];
        else
            MPI_Recv(&value, 1, MPI_INT, 0, 0, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
        if (value == X) {
            local_count++;
            local_sum += i;
        }
    }

    // Trimite datele locale către procesul master
    if (rank != 0) {
        MPI_Send(&local_count, 1, MPI_INT, 0, 1, MPI_COMM_WORLD);
        MPI_Send(&local_sum, 1, MPI_INT, 0, 2, MPI_COMM_WORLD);
    }

    // Procesul master adună rezultatele
    if (rank == 0) {
        int total_count = local_count;
        int total_sum = local_sum;
        for (int i = 1; i < size; i++) {
            int recv_count, recv_sum;
            MPI_Recv(&recv_count, 1, MPI_INT, i, 1, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
            MPI_Recv(&recv_sum, 1, MPI_INT, i, 2, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
            total_count += recv_count;
            total_sum += recv_sum;
        }
        printf("%d %d\n", total_count, total_sum);
        free(v);
    }

    MPI_Finalize();
    return 0;
}
